﻿#include  "StdAfx.h"

#include  <szCodecManager.hpp>
#include  <szArchiveDetector.hpp>
#include  <szArchiveEnumerator.hpp>
#include  <szArchiveContent.hpp>
#include  <szArchiveExtractor.hpp>
#include  <szArchiveUpdater.hpp>
#include  <szStoredItem.hpp>
#include  <szRuntimeException.hpp>
#include  <szFileArchiveVolume.hpp>
#include  <szPath.hpp>

#include  <cstdio>
#include  <clocale>

int _tmain(int argc, _TCHAR* argv[])
{
  using namespace std;
  using namespace szpp;

  locale::global(locale("japanese"));

  OnClientStartup(GetModuleHandle(0));
  SetCurrentTextCatalogPath(SZL("ja.lng"));

  if (argc > 2)
  {
    const szstring path(argv[1]), outputDir(argv[2]);
    FileArchiveVolume archiveVolume(path);

    // 列挙テスト
    auto_ptr<ArchiveHandler> handler(ArchiveDetector::FindHandlerFromExtension(ExtractExtension(path)));
    std::auto_ptr<ArchiveContent> content(ArchiveEnumerator::Enumerate(handler.get(), &archiveVolume, 1024 * 1000, 0, 0));
    u32 itemCount = content->GetNumberOfItems();
    for (u32 i = 0; i < itemCount; ++i)
    {
      const StoredItem *item = content->GetItem(i);
      
      _tprintf(_T("Item %d, Name %s\n"), i, item->GetName().c_str());
    }

    // シンプル展開テスト
    ArchiveExtractor::Extract(path, outputDir, 0, 0, 0, 0);

    // シンプル圧縮テスト
    std::vector<szstring> paths;
    paths.push_back(SZL("H:\\Workspace\\ULH3265D"));
    paths.push_back(SZL("H:\\Workspace\\top"));
    ArchiveUpdater::Update(paths, SZL("H:\\Workspace\\sample.7z"), 0, 0, 0);
  }

  OnClientShutdown();

	return 0;
}
